function smoothed = smooth_filter_spatial (mode, image)
%SMOOTH_FILTER_SPATIAL smoothes the image series spatically. 
%The filter used is determined by 'mode' 
%Input:
%	mode     --  filter coefficients of moving average filters, vector
%               '1'   --  [0.37  0.61 0.37;0.61 1 0.61;0.37 0.61 0.37]/(0.37*4+0.61*4+1);
%	image    --  input images, rownum*columnnum*timenum matrix
%Output:
%	smoothed --  output images, same dimensions as 'image'
%Hanzhang Lu
%Date: 03/28/02

%basic paramters of inputs
rownum=size(image, 1);
columnnum=size(image, 2);
timenum=size(image, 3);
smoothed=zeros(rownum, columnnum, timenum);


if mode==1
   temp1=zeros(rownum, columnnum);
   ir=[0.1  0.3 0.1;0.3 1 0.3;0.1 0.3 0.1]/(0.1*4+0.3*4+1); %ad hoc filter
   for i=1:timenum
      temp1(:,:)=image(:,:,i);
      temp2=filter2(ir, temp1, 'same');
      temp1(2:rownum-1,2:columnnum-1)=temp2(2:rownum-1,2:columnnum-1);
      smoothed(:,:,i)=temp1(:,:);
   end
elseif mode==2
   temp1=zeros(rownum, columnnum);
   ir=[0.0288  0.17 0.0288;0.17 1 0.17;0.0288 0.17 0.0288]/(0.17*4+0.0288*4+1); %Gaussian filter with  FWHM=5mm (sigma=2.1233mm) for voxel size of 4mmx4mm
   for i=1:timenum
      temp1(:,:)=image(:,:,i);
      temp2=filter2(ir, temp1, 'same');
      temp1(2:rownum-1,2:columnnum-1)=temp2(2:rownum-1,2:columnnum-1);
      smoothed(:,:,i)=temp1(:,:);
   end
elseif mode==3
   temp1=zeros(rownum, columnnum);
   ir=[0.09  0.29 0.09;0.29 1 0.29;0.09 0.29 0.09]/(0.09*4+0.29*4+1); %Gaussian filter with FWHM=6mm (for 4*4 voxels, sigma=3.6mm)
   for i=1:timenum
      temp1(:,:)=image(:,:,i);
      temp2=filter2(ir, temp1, 'same');
      temp1(2:rownum-1,2:columnnum-1)=temp2(2:rownum-1,2:columnnum-1);
      smoothed(:,:,i)=temp1(:,:);
   end
elseif mode==4
   temp1=zeros(rownum, columnnum);
   ir=[ 0.0442, 0.0874,0.1423,0.1907,0.2102,0.1907,0.1423,0.0874,0.0442;...
         0.0874,0.1730,0.2816,0.3773,0.4159,0.3773,0.2816,0.1730,0.0874;...
         0.1423,0.2816,0.4585,0.6142,0.6771,0.6142,0.4585,0.2816,0.1423;...
         0.1907,0.3773,0.6142,0.8229,0.9071,0.8229,0.6142,0.3773,0.1907;...
         0.2102,0.4159,0.6771,0.9071,1,0.9071,0.6771,0.4159,0.2102;...
         0.1907,0.3773,0.6142,0.8229,0.9071,0.8229,0.6142,0.3773,0.1907;...
         0.1423,0.2816,0.4585,0.6142,0.6771,0.6142,0.4585,0.2816,0.1423;...
         0.0874,0.1730,0.2816,0.3773,0.4159,0.3773,0.2816,0.1730,0.0874;...
      0.0442, 0.0874,0.1423,0.1907,0.2102,0.1907,0.1423,0.0874,0.0442];
   ir = ir/sum(sum(ir));%Gaussian filter with  FWHM=5mm (sigma=2.1233mm) for voxel size of 3.75/4mmx3.75/4mm 
   for i=1:timenum
      temp1(:,:)=image(:,:,i);
      temp2=filter2(ir, temp1, 'same');
      temp1(5:rownum-4,5:columnnum-4)=temp2(5:rownum-4,5:columnnum-4);
      smoothed(:,:,i)=temp1(:,:);
   end
elseif mode==5
   temp1=zeros(rownum, columnnum);
   ir=[ 0.0442, 0.2102, 0.0442;...
        0.2102, 1,      0.2102;...
        0.0442, 0.2102, 0.0442];
   ir = ir/sum(sum(ir));%Gaussian filter with  FWHM=5mm (sigma=2.1233mm) for voxel size of 3.75mmx3.75mm 
   for i=1:timenum
      temp1(:,:)=image(:,:,i);
      temp2=filter2(ir, temp1, 'same');
      temp1(2:rownum-1,2:columnnum-1)=temp2(2:rownum-1,2:columnnum-1);
      smoothed(:,:,i)=temp1(:,:);
   end
elseif mode==6
   temp1=zeros(rownum, columnnum);
   ir=[ 0.2957, 0.5438, 0.2957;...
        0.5438, 1,      0.5438;...
        0.2957, 0.5438, 0.2957];
   ir = ir/sum(sum(ir));%Gaussian filter with  FWHM=5mm (sigma=2.1233mm) for voxel size of 3.75mmx3.75mm 
   for i=1:timenum
      temp1(:,:)=image(:,:,i);
      temp2=filter2(ir, temp1, 'same');
      temp1(2:rownum-1,2:columnnum-1)=temp2(2:rownum-1,2:columnnum-1);
      smoothed(:,:,i)=temp1(:,:);
   end
elseif mode==7
   temp1=zeros(rownum, columnnum);
   ir=[  0.0009, 0.0063, 0.0203, 0.0299, 0.0203, 0.0063, 0.0009;... 
         0.0063, 0.0442, 0.1423, 0.2102, 0.1423, 0.0442, 0.0063;...
         0.0203, 0.1423, 0.4585, 0.6771, 0.4585, 0.1423, 0.0203;...
         0.0299, 0.2102, 0.6771, 1,      0.6771, 0.2102, 0.0299;...
         0.0203, 0.1423, 0.4585, 0.6771, 0.4585, 0.1423, 0.0203;...
         0.0063, 0.0442, 0.1423, 0.2102, 0.1423, 0.0442, 0.0063;...
         0.0009, 0.0063, 0.0203, 0.0299, 0.0203, 0.0063, 0.0009];
   ir = ir/sum(sum(ir));%Gaussian filter with  FWHM=10mm (sigma=2.1233mm) for voxel size of 3.75mmx3.75mm 
   for i=1:timenum
      temp1(:,:)=image(:,:,i);
      temp2=filter2(ir, temp1, 'same');
      temp1(4:rownum-3,4:columnnum-3)=temp2(4:rownum-3,4:columnnum-3);
      smoothed(:,:,i)=temp1(:,:);
   end   
end







   
