function [dd] = mmontagebase(d, bb)

%%  Check to see if it is something which is shaped to be passed into montage
if( size(d, 3) == 1 )
    d = squeeze(d);
end

if( nargin == 1 | isempty(bb) )
	%%  Calculate the number of columns
	nr = ceil( sqrt(size(d,3)) );
	nc = ceil(size(d,3) / nr);
else
	nr = bb(1);
	nc = bb(2);
end

sx = size(d, 1);
sy = size(d, 2);

dd = zeros( sx * nr, sy * nc );

sl=1;
for rr = 1:nr
    for cc = 1:nc
        
        if( sl <= size(d, 3) )
            row_start = (rr - 1) * sx + 1;
            row_end = rr * sx;
            col_start = (cc - 1) * sy + 1;
            col_end = cc * sy;
        
            dd(row_start:row_end, col_start:col_end) = d(:,:,sl);
        
            sl = sl + 1;
        end
    end
end
