% ========================================================================
% ========================================================================
% ========================================================================
% Author: Manus J. Donahue
% Email: mj.donahue@vanderbilt.edu
% Tel: 615.322.8350
%
% Date: 13 April 2015
% Purpose: GUI to load DCM or Philips PAR/REC pCASL data, quantify CBF, and
% save .nii.gz files for CBF and M0
%
% The function requires FSL to be installed and in path if motion
% correction option is enabled
%
% The quantificaiton equation is the 2014 ISMRM white paper simplified
% model (single-compartment flow-modified Bloch equation).
%
% ========================================================================
% ========================================================================
% ========================================================================


function varargout = mjdASL(varargin)
% MJDASL MATLAB code for mjdASL.fig
%      MJDASL, by itself, creates a new MJDASL or raises the existing
%      singleton*.
%
%      H = MJDASL returns the handle to a new MJDASL or the handle to
%      the existing singleton*.
%
%      MJDASL('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MJDASL.M with the given input arguments.
%
%      MJDASL('Property','Value',...) creates a new MJDASL or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before mjdASL_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to mjdASL_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help mjdASL

% Last Modified by GUIDE v2.5 13-Apr-2015 13:15:06

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @mjdASL_OpeningFcn, ...
    'gui_OutputFcn',  @mjdASL_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT




% --- Executes just before mjdASL is made visible.
function mjdASL_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to mjdASL (see VARARGIN)

% This mostly suppresses the fileparts warning in read_avw and associated
% scripts
warning off; 

% Choose default command line output for mjdASL
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% Make the output figures initially black, otherwise these boxes look bad
axes(handles.iaxis1); imagesc(zeros(1,1)); colormap(gray); axis off;
axes(handles.iaxis2); imagesc(zeros(1,1)); colormap(gray); axis off;
axes(handles.iaxis3); imagesc(zeros(1,1)); colormap(gray); axis off;

% UIWAIT makes mjdASL wait for user response (see UIRESUME)
% uiwait(handles.figure1);




% --- Outputs from this function are returned to the command line.
function varargout = mjdASL_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



% --- Executes on button press in checkbox1.
function checkbox1_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox1



% --- Executes on button press in checkbox2.
function checkbox2_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox2



% --- Executes on button press in checkbox3.
function checkbox3_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox3



function edit2_Callback(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit2 as text
%        str2double(get(hObject,'String')) returns contents of edit2 as a double



% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double
input=get(handles.edit3,'String');



% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ilabeldur_Callback(hObject, eventdata, handles)
% hObject    handle to ilabeldur (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ilabeldur as text
%        str2double(get(hObject,'String')) returns contents of ilabeldur as a double


% --- Executes during object creation, after setting all properties.
function ilabeldur_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ilabeldur (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to ilabeldur (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ilabeldur as text
%        str2double(get(hObject,'String')) returns contents of ilabeldur as a double



% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ilabeldur (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function itr_Callback(hObject, eventdata, handles)
% hObject    handle to itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of itr as text
%        str2double(get(hObject,'String')) returns contents of itr as a double



% --- Executes during object creation, after setting all properties.
function itr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to itr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ite_Callback(hObject, eventdata, handles)
% hObject    handle to ite (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ite as text
%        str2double(get(hObject,'String')) returns contents of ite as a double



% --- Executes during object creation, after setting all properties.
function ite_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ite (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



% --- Executes on button press in icalccbf.
function icalccbf_Callback(hObject, eventdata, handles)
% hObject    handle to icalccbf (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% ========================================================================
% ========================================================================
% ========================================================================
%
% CALCULATE CBF BELOW:
%
% ========================================================================
% ========================================================================
% ========================================================================

filename1=get(handles.selectafile,'String');
temp=char(filename1);
fileext=filename1(end-2:end);
type=0;

if fileext=='REC'| fileext=='rec'
    type=1;
end

if fileext=='dcm' | fileext=='DCM'
    type=2;
end

if type==0
    error('Error. File type not recognized')
end


% PAR/REC format ==========================
% ========================================================================
% ========================================================================

if type == 1
    
    % Update progress watcher...............
    set(handles.oprogress,'String','Reading PAR/REC ASL data...');
    
    [datain,getfovasl,readthickasl,readtrasl]=readrec_aslgui(filename1);
    
    datain=squeeze(datain); 
    aslfovx=getfovasl(1);
    aslfovy=getfovasl(3);
    
    spatresx=aslfovx/(size(datain,1)); % same for m0 and asl
    spatresy=aslfovy/(size(datain,2)); % same for m0 and asl
    spatresz=readthickasl; % same for m0 and asl
    
    % Motion correction ===============================================
    
    % Update progress watcher...............
    set(handles.oprogress,'String','Motion correcting...');
    
    if get(handles.imotioncorrect,'Value')==1
        domc=1;
        datain=fun_veasl_mc_aslgui(datain,spatresx,spatresy,spatresz,0);
    end
    
    % End motion correction ===========================================
    
    
    % Check for surround subtraction ==================================
    
    if get(handles.isurround,'Value')==0
        mdm=datain(:,:,:,:,1)-datain(:,:,:,:,2);
    end
    
    if get(handles.isurround,'Value')==1
        for td=1:(size(datain,4)-1)
            dummydm(:,:,:,td)=((datain(:,:,:,td,1)+datain(:,:,:,td+1,1))/2)-datain(:,:,:,td,2);
        end
        size(dummydm);
        mdm=mean(dummydm,4);
    end
    % End subtraction / surround subtraction ==========================
    
    mdm=mean(mdm,4);
    m0=squeeze(datain(:,:,:,:,1));
    m0=mean(m0,4);
    
    % If you are going to calculate M0 this way, then you need to convert
    % the magnetization to equilibrium:
   
    % Note: readtrasl is in ms
    str2double(get(handles.it1t,'String')); % ms
    m0=m0./(1-exp(-readtrasl/str2double(get(handles.it1t,'String'))));
    
end

% End PAR/REC format =======================
% ========================================================================
% ========================================================================

% ========================================================================
% ========================================================================
% DICOM format ==========================
if type==2
    
    % Update progress watcher...............
    set(handles.oprogress,'String','Reading DICOM ASL data...');
    
    mydicom=double(squeeze(dicomread(filename1)));
    aslinfo=dicominfo(filename1);
    
    % Calculate the scaling parameters
    asl_d_rs = aslinfo.PerFrameFunctionalGroupsSequence.Item_1.Private_2005_140f.Item_1.RescaleSlope;
    asl_d_ri = aslinfo.PerFrameFunctionalGroupsSequence.Item_1.Private_2005_140f.Item_1.RescaleIntercept;
    asl_d_ss = aslinfo.PerFrameFunctionalGroupsSequence.Item_1.Private_2005_140f.Item_1.Private_2005_100e;
    
    % Scale the data correctly
    mydicom = (mydicom * asl_d_rs + asl_d_ri)/(asl_d_rs * asl_d_ss);
    
    % Imaging parameters
    spatresx=aslinfo.PerFrameFunctionalGroupsSequence.Item_28.PixelMeasuresSequence.Item_1.PixelSpacing(1);
    spatresy=aslinfo.PerFrameFunctionalGroupsSequence.Item_28.PixelMeasuresSequence.Item_1.PixelSpacing(2);
    spatresz=aslinfo.PerFrameFunctionalGroupsSequence.Item_28.PixelMeasuresSequence.Item_1.SliceThickness;
    savetrasl=(aslinfo.Private_2005_1030)/1000; % TR in seconds
    slices=aslinfo.Private_2001_1018;
    measurements=aslinfo.Private_2001_1081;
    xdim=aslinfo.Rows;
    ydim=aslinfo.Columns;
    
    % Reorder the data correctly ========================
    
    asl_reorder1=zeros(xdim,ydim,measurements,slices);
    asl_reorder2=asl_reorder1;
    data1=mydicom(:,:,1:(size(mydicom,3)/2));
    data2=mydicom(:,:,((size(mydicom,3)/2)+1):size(mydicom,3));
    
    for ns=1:slices
        mystart=ns-1;
        asl_reorder1(:,:,:,ns)=data1(:,:,(mystart*measurements+1):(mystart*measurements+measurements));
        asl_reorder2(:,:,:,ns)=data2(:,:,(mystart*measurements+1):(mystart*measurements+measurements));
    end
    
    asl_reorder1=permute(asl_reorder1,[1 2 4 3]);
    asl_reorder2=permute(asl_reorder2,[1 2 4 3]);
    
    % End re-order of data ===============================
    
    % Group the data the same as for par/rec so that motion correction and
    % surround subtraction works the same way
    
    ddatain(:,:,:,:,1)=asl_reorder1; % control data
    ddatain(:,:,:,:,2)=asl_reorder2; % label data
    
    
    % Motion correction ==================================
    
    % Update progress watcher...............
    set(handles.oprogress,'String','Motion correcting...');
    
    if get(handles.imotioncorrect,'Value')==1
        
        ddatain=fun_veasl_mc_aslgui(ddatain,spatresx,spatresy,spatresz,0);
    end
    
    % End motion correction ==============================
    
    
    % ====================================================
    % Calculate the difference using pair-wise subtraction
    
    if get(handles.isurround,'Value')==0
        
        dm=ddatain(:,:,:,:,1)-ddatain(:,:,:,:,2);
        mdm=squeeze(mean(dm,4));
    
    end
    
    if get(handles.isurround,'Value')==1
        for td=1:(size(ddatain,4)-1)
            dummydm(:,:,:,td)=((ddatain(:,:,:,td,1)+ddatain(:,:,:,td+1,1))/2)-ddatain(:,:,:,td,2);
        end
        
        mdm=mean(dummydm,4);
    
    end
    
    % End check subtraction / surround subtraction 
    % ====================================================   
    
    m0=mean(asl_reorder1,4);
    
    % If you are going to calculate M0 this way, then you need to convert
    % the magnetization to equilibrium:
   
    % Note: readtrasl is in ms
    readtrasl=savetrasl*1000; % ms
    str2double(get(handles.it1t,'String')); % ms
    m0=m0./(1-exp(-readtrasl/str2double(get(handles.it1t,'String'))));
    
    %mdm_m0=mdm./m0;
end
% End DICOM format =======================
% ========================================================================
% ========================================================================

% ========================================================================
% ========================================================================
% M0 determination =================
if get(handles.havem0,'Value')==1
    
    filenamem0=get(handles.selectm0,'String');
    
    % PAR/REC format ==========================
    if type==1
        
    % Update progress watcher...............
    set(handles.oprogress,'String','Reading PAR/REC M0 data...');
        
        [myrecm0,getfovm0,readthickm0,readtrm0]=readrec_aslgui(filenamem0);
        myrecm0=squeeze(myrecm0);
        m0fovx=getfovm0(1);
        m0fovy=getfovm0(3);
        
        m0 = myrecm0; % this will overwrite the control image being used for M0 (which is the default if separate M0 box not checked)
    end
    % End PAR/REC format ======================
    
    % DICOM format ==========================
    if type==2
        
    % Update progress watcher...............
    set(handles.oprogress,'String','Reading DICOM M0 data...');
        
        mydicomm0=double(squeeze(dicomread(filenamem0)));
        m0info=dicominfo(filenamem0);
        
        m0_d_rs = m0info.PerFrameFunctionalGroupsSequence.Item_1.Private_2005_140f.Item_1.RescaleSlope;
        m0_d_ri = m0info.PerFrameFunctionalGroupsSequence.Item_1.Private_2005_140f.Item_1.RescaleIntercept;
        m0_d_ss = m0info.PerFrameFunctionalGroupsSequence.Item_1.Private_2005_140f.Item_1.Private_2005_100e;
        
        mydicomm0 = (mydicomm0 * m0_d_rs + m0_d_ri)/(m0_d_rs * m0_d_ss);
        
        m0 = mydicomm0; % this will overwrite the control image being used for M0 (which is the default if separate M0 box not checked)
        
    end
    % End DICOM format ==========================
end

% End M0 determination =================
% ========================================================================
% ========================================================================

% ========================================================================
% ========================================================================
% CBF quantification parameters ==========================================

    % Update progress watcher...............
    set(handles.oprogress,'String','Quantifying CBF...');

slicetime=str2double(get(handles.islactime,'String')); % ms; time to acquire one slice of the EPI readout - need to increment the PLD by this
lambda=0.9; % ml/g
tau=str2double(get(handles.ilabeldur,'String'))/1000; % label duration; s

% Blood T1 determination ======================================================

t1a=str2double(get(handles.it1b,'String'))/1000; % T1 of arterial blood water at 3T; s

% If Hct-corrected T1a is on, then need to calculate T1a and populate the
% Blood T1 field

if get(handles.ihctt1,'Value')==1
    
    r1a=0.52*str2double(get(handles.ihct,'String'))+0.38; % equation from lu and van zijl; t1 of blood
    t1a=1./r1a;
    t1a2show=t1a*1000;
    set(handles.it1b,'String',t1a2show);

end

% End Blood T1 determination section ===============

alpha=str2double(get(handles.ilabeleff,'String')); % pCASL labeling efficiency in extracranial ICA
slicetimesec=slicetime/1000; % slice time in ms
pldsec=str2double(get(handles.ipld,'String'))/1000;
wz=pldsec:slicetimesec:(pldsec+slicetimesec*(size(mdm,3)-1)); % the corrected PLD for slice timing
mym0=m0; % This is essentially the M0, with coil sensitivity included. TR=4s, so close to equilibrium for cortex

for ss=1:size(mdm,3)
    
    % ISMRM study group model:
    f_total=(lambda*mdm(:,:,ss).*exp(wz(ss)./t1a))./(2.*alpha.*t1a.*mym0(:,:,ss).*(1-exp(-tau./t1a)));
    f_total=f_total.*(100*60); % to go to ml/100g/min
    cbfmap_total(:,:,ss)=f_total; % CBF map over entire volume
    
end
% End quantify CBF

% Check if need to smooth =======

if get(handles.ismooth,'Value')==1
    cbfmap_total=smooth_filter_spatial(2,cbfmap_total);
    m0=smooth_filter_spatial(2,m0);
end

% End check smooth =========================

% Now can calculate mdm / m0 and the correct m0 will be used
mdm_m0=mdm./m0;

% Calculate the mask =====================================

    % Update progress watcher...............
    set(handles.oprogress,'String','Calculating mask...');

maskthresh=str2double(get(handles.imaskthold,'String'));
mymask=image_mask(mym0,10,10,maskthresh);

% End calculate the mask =================================


% Show the output ====================

    % Update progress watcher...............
    set(handles.oprogress,'String','Determing outputs...');

axes(handles.iaxis1); imagesc(mymask(:,:,round(size(m0,3)/2)).*mdm_m0(:,:,round(size(m0,3)/2))); caxis([0 0.01]); impixelinfo; axis off;
axes(handles.iaxis2); imagesc(mymask(:,:,round(size(m0,3)/2)).*cbfmap_total(:,:,round(size(m0,3)/2)));caxis([0 75]); impixelinfo; axis off;
axes(handles.iaxis3); imagesc(mymask(:,:,round(size(m0,3)/2)).*m0(:,:,round(size(m0,3)/2))); impixelinfo; axis off;

% End show output ===================

% Calculate the output ==============

allcbfvals=cbfmap_total(find(mymask==1 & cbfmap_total~=Inf));
allmdm0=mdm_m0(find(mymask==1));

allcbfvals=allcbfvals(find(allcbfvals>0)); % don't consider values <=0; this is just a basic check
allmdmm0=allmdm0(find(allmdm0>0 & allmdm0~=Inf)); % don't consider values <=0; this is just a basic check

cbfrange=iqr(allcbfvals);
cbfmean=nanmean(allcbfvals);

cbfstd=std(allcbfvals,[],1);
cbfrange=iqr(allcbfvals);

mdmm0mean=nanmean(allmdmm0,1);

% Update the boxes with the calculated parameters

set(handles.ocbfmean,'String',cbfmean);
set(handles.ocbfstd,'String',cbfstd);
set(handles.ocbfiqrl,'String',cbfmean-(cbfrange/2));
set(handles.ocbfiqrh,'String',cbfmean+(cbfrange/2));
set(handles.odeltamm0mean,'String',mdmm0mean);


% Save images ===============
% ============================================

    % Update progress watcher...............
    set(handles.oprogress,'String','Saving images...');

if get(handles.isaveimgs,'Value')==1
    
    if type==1 % PAR/REC format

        savetrm0=readtrasl/1000; % m0 tr in sec
        savetrasl=readtrasl/1000; % m0 tr in sec for asl
        
        % Need to overwrite TR for M0 if separate M0 image is used
        if get(handles.havem0,'Value')==1
            savetrm0=readtrm0/1000; % tr in sec
        end
        % End separate M0
        
        % Orient for saving to nifti
        for ns=1:size(cbfmap_total,3)
            cbfmap2save(:,:,ns)=fliplr((cbfmap_total(:,:,ns)));
            m02save(:,:,ns)=fliplr((m0(:,:,ns)));
        end
        
        filenamesave=char(filename1);
        filenamesave=filenamesave(1:(end-4));
        save_avw(st2(cbfmap2save),strcat(filenamesave,'_CBF'),'d',[spatresx spatresy spatresz savetrasl]);
        save_avw(st2(m02save),strcat(filenamesave,'_M0'),'d',[spatresx spatresy spatresz savetrm0]);
        
    end
    
    if type==2 % DICOM format
        
        savetrm0=(aslinfo.Private_2005_1030)/1000; % TR in seconds
        
        % Need to overwrite TR for M0 if separate M0 image is used
        if get(handles.havem0,'Value')==1
            savetrm0=(m0info.Private_2005_1030)/1000; % TR in seconds;
        end
        % End separate M0
        
        % Orient for saving to nifti
        for ns=1:size(cbfmap_total,3)
            cbfmap2save(:,:,ns)=fliplr((cbfmap_total(:,:,ns)));
            m02save(:,:,ns)=fliplr((m0(:,:,ns)));
        end
        
        filenamesave=char(filename1);
        filenamesave=filenamesave(1:(end-4));
        save_avw(st2(cbfmap2save),strcat(filenamesave,'_CBF'),'d',[spatresx spatresy spatresz savetrasl]);
        save_avw(st2(m02save),strcat(filenamesave,'_M0'),'d',[spatresx spatresy spatresz savetrm0]);
        
    end
    
end

% End save images
% ==============================================

% Check if need to show the montage =======

if get(handles.ishowmontage,'Value')==1
    figure; mmontage(mymask.*cbfmap_total); colormap(jet); caxis([0 100]); impixelinfo; colorbar;
    figure; mmontage(mymask.*m0); colormap(gray); impixelinfo; colorbar;
end

% End check show montage ==================

    % Update progress watcher...............
    set(handles.oprogress,'String','Finished successfully');

% End Calculate the CBF ===========================================
% =================================================================
% =================================================================



function it1b_Callback(hObject, eventdata, handles)
% hObject    handle to it1b (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of it1b as text
%        str2double(get(hObject,'String')) returns contents of it1b as a double


% --- Executes during object creation, after setting all properties.
function it1b_CreateFcn(hObject, eventdata, handles)
% hObject    handle to it1b (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ihct_Callback(hObject, eventdata, handles)
% hObject    handle to ihct (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ihct as text
%        str2double(get(hObject,'String')) returns contents of ihct as a double


% --- Executes during object creation, after setting all properties.
function ihct_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ihct (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function imaskthold_Callback(hObject, eventdata, handles)
% hObject    handle to imaskthold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of imaskthold as text
%        str2double(get(hObject,'String')) returns contents of imaskthold as a double


% --- Executes during object creation, after setting all properties.
function imaskthold_CreateFcn(hObject, eventdata, handles)
% hObject    handle to imaskthold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function it1t_Callback(hObject, eventdata, handles)
% hObject    handle to it1t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of it1t as text
%        str2double(get(hObject,'String')) returns contents of it1t as a double


% --- Executes during object creation, after setting all properties.
function it1t_CreateFcn(hObject, eventdata, handles)
% hObject    handle to it1t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function islactime_Callback(hObject, eventdata, handles)
% hObject    handle to islactime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of islactime as text
%        str2double(get(hObject,'String')) returns contents of islactime as a double


% --- Executes during object creation, after setting all properties.
function islactime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to islactime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ilabeleff_Callback(hObject, eventdata, handles)
% hObject    handle to ilabeleff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ilabeleff as text
%        str2double(get(hObject,'String')) returns contents of ilabeleff as a double


% --- Executes during object creation, after setting all properties.
function ilabeleff_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ilabeleff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in icoregister.
function icoregister_Callback(hObject, eventdata, handles)
% hObject    handle to icoregister (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of icoregister


% --- Executes on button press in isaveimgs.
function isaveimgs_Callback(hObject, eventdata, handles)
% hObject    handle to isaveimgs (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of isaveimgs

% --- Executes on button press in browse.
function browse_Callback(hObject, eventdata, handles)
% hObject    handle to browse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[c, b] =uigetfile({'*.REC; *.rec; *.dcm; *.DCM'},'Select REC or DCM file');
d=get(handles.selectafile,'string');
% e=get(handles.FSG,'string')
% C{end+1}=fullfile(b,c);
% d{1:end}=C{end:1};
d=fullfile(b,c); % NOTE: b is the directory path
set(handles.selectafile,'string',d);
% set(handles.FSG,'string',e);
guidata(hObject,handles);



% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1


% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function selectafile_CreateFcn(hObject, eventdata, handles)
% hObject    handle to selectafile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ipld_Callback(hObject, eventdata, handles)
% hObject    handle to ipld (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ipld as text
%        str2double(get(hObject,'String')) returns contents of ipld as a double


% --- Executes during object creation, after setting all properties.
function ipld_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ipld (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function selectm0_CreateFcn(hObject, eventdata, handles)
% hObject    handle to selectm0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in havem0.
function havem0_Callback(hObject, eventdata, handles)
% hObject    handle to havem0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of havem0


% --- Executes on button press in browsem0.
function browsem0_Callback(hObject, eventdata, handles)
% hObject    handle to browse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[c, b] =uigetfile({'*.REC; *.rec; *.dcm; *.DCM'},'Select REC or DCM file');
d=get(handles.selectm0,'string');
% e=get(handles.FSG,'string')
% C{end+1}=fullfile(b,c);
% d{1:end}=C{end:1};
d=fullfile(b,c);
set(handles.selectm0,'string',d);
% set(handles.FSG,'string',e);
guidata(hObject,handles);


% --- Executes on button press in imotioncorrect.
function imotioncorrect_Callback(hObject, eventdata, handles)
% hObject    handle to imotioncorrect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of imotioncorrect


% --- Executes on button press in ihctt1.
function ihctt1_Callback(hObject, eventdata, handles)
% hObject    handle to ihctt1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of ihctt1


% --- Executes on button press in isurround.
function isurround_Callback(hObject, eventdata, handles)
% hObject    handle to isurround (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of isurround


% --- Executes on selection change in popupmenu4.
function popupmenu4_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu4 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu4


% --- Executes during object creation, after setting all properties.
function popupmenu4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in ishowmontage.
function ishowmontage_Callback(hObject, eventdata, handles)
% hObject    handle to ishowmontage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of ishowmontage


% --- Executes on button press in ismooth.
function ismooth_Callback(hObject, eventdata, handles)
% hObject    handle to ismooth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of ismooth
