function [] = mimage(data, cm)

% $Id: mimage.m,v 1.9 2002/03/14 22:39:55 resadmin Exp $

% $Log: mimage.m,v $
% Revision 1.9  2002/03/14 22:39:55  resadmin
% Minor tweak for better mview compatibility.
%
% Revision 1.8  2001/09/13 23:09:54  erick
% The great name switchover.  mimage is back to normal, mview is now interactive.
%
% Revision 1.1  2001/09/06 22:19:49  erick
% Added interactivity to mimage, mimagecb, mimagecov, and shademask (now mimagesm).
% Added voltrans for transposing volumes (the new mimages don't do it automatically).
%
% Moved old mimage and mimagecb to mimage_dumb and mimagecb_dumb
%
% Updated msmri.html
%
% Revision 1.5  2001/08/09 20:52:21  erick
% No longer anchors the window.
%
% Revision 1.4  2001/08/09 20:50:55  erick
% Doublebuffer on
%
% Revision 1.3  2001/06/14 15:28:20  craig
% Fixed up the paper position field so that when I do a print -depsc it comes out in the right aspect ratio
%
% Revision 1.1  1999/02/25 20:34:11  craig
% Initial revision
%

if nargin == 1
   cm = gray(256);
end


% Plot the image.
imagesc(data); 

% Set the colormap.
colormap(cm);

% Set the axis.
axis off;
axis image;

% Make it larger.
pf = get(gcf, 'position');
%set(gcf, 'units', 'pixels', 'position', [pf(1:2) 400 400]);
set(gca, 'units', 'normalized', 'position', [0 0 1 1]);
set(gcf, 'menubar', 'none');

pf = get(gcf, 'paperposition');
set(gcf, 'units', 'inches', 'paperposition', [1 1 2.5 2.5]);
set(gcf,'doublebuffer','on');
