% Author: Manus J. Donahue
% Date: 03-10-04
% Function generates a mask (matrix of 1s and 0s)
% (e.g. image_mask(argin, xbox, ybox, thold) for 16X16 corner box would be image_mask(argin, 16, 16, 5)

% --------------Generate a Mask-------------------

function allmasks = image_mask(argin, xbox, ybox, thold)

xbox = xbox-1;
ybox = ybox-1;
v=1;
for img=1:size(argin,3);
for px=0:xbox
    for py=0:ybox
        tmul(v)=argin(px+1,py+1,img);
        tmbl(v)=argin(px+1,size(argin,2)-py,img);
        tmur(v)=argin(size(argin,1)-px,py+1,img);
        tmbr(v)=argin(size(argin,1)-px,size(argin,2)-py,img);
        v=v+1;
    end
end

tmean=.25*(mean(tmul,1)+mean(tmbl,1)+mean(tmur,1)+mean(tmbr,1));
themask = zeros(size(argin,1),size(argin,2));
for xi=1:size(argin,1)
    for yi=1:size(argin,2)
        if argin(xi,yi,img) > (thold)*tmean
            themask(xi,yi)=1;
        end
    end
end
allmasks(:,:,img)=themask(:,:);
end
%image_showc(image_transpose(themask),1);

% -----------------------------------------------