% Author: Manus J. Donahue
% Date: 8 April 2013
% Perform motion correction using FLIRT of ASL data
% [corrected_data]=fun_veasl_mc(datain,voxel_size_x,voxel_size_y,voxe_size_z,0/1)
% voxel_sizes are in mm
% 0 = no BET
% 1 = use BET


function [mc_veasl_data] = fun_veasl_mc_aslgui(indata,sizeX,sizeY,sizeZ,usebet);

dimx=size(indata,1);
dimy=size(indata,2);
fslice=size(indata,3);
fdyns=size(indata,4);

%ftemp=permute(indata,[1 2 4 3 5]);
ftemp2=reshape(indata,[dimx dimy fslice fdyns*2]);

save_avw(ftemp2,'TEMP_VEASL_MC','d',[sizeX sizeY sizeZ]);

if usebet==1
unix('bet TEMP_VEASL_MC TEMP_VEASL_MC -F'); 
end

unix('mcflirt -in TEMP_VEASL_MC -out TEMP_VEASL_MC_MCF');
ftemp2=read_avw('TEMP_VEASL_MC_MCF');
ftemp2=reshape(ftemp2,[dimx dimy fslice fdyns 2]);
%ftemp2=permute(ftemp2,[1 2 4 3 5]);
unix('rm TEMP_VEASL_MC.nii.gz');
unix('rm TEMP_VEASL_MC_MCF.nii.gz');
unix('rm TEMP_VEASL_MC_mask.nii.gz');
mc_veasl_data=ftemp2;
